unit Objedit;

interface

uses
    sysUtils,
    WinTypes,
    WinProcs,
    Classes,
    Graphics,
    Forms,
    Controls,
    Buttons,
    StdCtrls,
    ExtCtrls,
    dialogs,
    NwProp,
    Nwtools,
    Nwlib;

type
  TwinObjEdit = class(TForm)
    bSave: TBitBtn;
    bCancel: TBitBtn;
    NWLib1: TNWLib;
    NWTools1: TNWTools;
    NWProp1: TNWProp;
    bGroups: TBitBtn;
    bRights: TBitBtn;
    bMembers: TBitBtn;
    dataPanel: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    label3: TLabel;
    fullName: TEdit;
    objName: TEdit;
    readFlags: TRadioGroup;
    writeFlags: TRadioGroup;
    objType: TRadioGroup;
    duration: TRadioGroup;
    password: TEdit;
    bProperties: TBitBtn;
    procedure bSaveClick(Sender: TObject);
    procedure objTypeClick(Sender: TObject);
    procedure bMembersClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure bPropertiesClick(Sender: TObject);
    procedure bGroupsClick(Sender: TObject);
    procedure bRightsClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    creating : boolean ;
  end;

var
  winObjEdit: TwinObjEdit;

implementation

{$R *.DFM}

uses
  list ;

procedure TwinObjEdit.FormShow(Sender: TObject);
  var
    canRead       : boolean ;
    canWrite      : boolean ;
    hasProperties : boolean ;
    readSecurity  : TNWFlags ;
    writeSecurity : TNWFlags ;
  begin
    if (not creating) then
      begin
        objName.enabled := false ;
        compareObjectAccessRights(getPrimaryServerID,
                                  objName.text,
                                  canRead,
                                  canWrite) ;
        getObjectInfo(getPrimaryServerID,
                      objName.text,
                      hasProperties,
                      readSecurity,
                      writeSecurity) ;

       { show object read rights }
        case readSecurity of
          BS_ANY_READ    :
            readFlags.itemIndex := 0 ;
          BS_LOGGED_READ :
            readFlags.itemIndex := 1 ;
          BS_OBJECT_READ :
            readFlags.itemIndex := 2 ;
        else
          readFlags.itemIndex := 3 ;
        end;
        { show object write rights }
        case writeSecurity of
          BS_ANY_WRITE    :
            writeFlags.itemIndex := 0 ;
          BS_LOGGED_WRITE :
            writeFlags.itemIndex := 1 ;
          BS_OBJECT_WRITE :
            writeFlags.itemIndex := 2 ;
        else
          writeFlags.itemIndex := 3 ;
        end;

        { set Object Type }
        objType.itemIndex := 0 ;
        case getObjType(0,objName.text) of
          nw_user :
            begin
              bGroups.enabled := true ;
              objType.itemIndex := 0 ;
            end;
          nw_group :
            begin
              objType.itemIndex := 1 ;
            end;
          nw_printQ :
            begin
              objType.itemIndex := 2 ;
            end;
          nw_printServer :
            begin
              objType.itemIndex := 3 ;
            end;
        end;

        {enable/disable buttons, etc. on object type }
        objTypeClick(sender) ;

        { check object rights -
           disable all entry fields if no obj write ability }
        datapanel.enabled := canWrite ;
      end ; 
  end;

procedure TwinObjEdit.bSaveClick(Sender: TObject);
  var
    readAccess,
    writeAccess : TNWFlags ;
    oType       : TObjType ;
    loginCtrl   : TNWLoginControl ;
  begin
    if YesNoBox('Saving Object Information;;Are You Sure') then
      begin
        case objType.itemIndex of
          1: oType := nw_group ;
          2: oType := nw_printQ ;
          3: oType := nw_printServer ;
        else
          oType := nw_user;
        end;
        { Convert Read Access Level }
        case readflags.itemIndex of
          0: readAccess := BS_ANY_READ ;
          2: readAccess := BS_OBJECT_READ ;
          3: readAccess := BS_SUPER_READ ;
        else
          readAccess := BS_LOGGED_READ ;
        end;
        { Convert Write Access Level }
        case writeflags.itemIndex of
          0: writeAccess := BS_ANY_WRITE ;
          2: writeAccess := BS_OBJECT_WRITE ;
          3: writeAccess := BS_SUPER_WRITE ;
        else
          writeAccess := BS_LOGGED_WRITE ;
        end;
        if creating then
          begin
            { creating new object }
            if createObject(getPrimaryServerID,
                            objName.text,
                            oType,
                            fullName.text,
                            password.text,
                            (duration.itemIndex = 0),
                            readAccess,
                            writeAccess) then
              begin
                {----> how to optionally set user/printserver login controls <----}
                (*
                with loginCtrl do begin
                  graceLogins              := 6  ;
                  expirationInterval       := 90 ;
                  graceReset               := 6  ;
                  minPasswordLength        := 6  ;
                  maxConcurrentConnections := 1  ;
                end;
                case oType of
                  nw_user,nw_printServer :
                    if setLoginControl(0,objName.text,  
                                   oType,loginCtrl) then
                      okBox('Object Created Successfully')
                    else
                      okBox('Object Created, But Error Writing LOGIN_CONTROL Property') ;  
                else
                  alertBox('Object Created Successfully') ;
                end;           
                *)
                okBox('Object Created Successfully') ;
                close;
              end
            else
              alertBox('Error Creating Object') ;
          end
        else
          { modifying existing object }
          begin
             writeItemProperty(getPrimaryServerID,
                               objName.text,
                               oType,
                               'IDENTIFICATION',
                               fullName.text) ; {remember, some objTypes 
                                                 have no identification property}
             if changeObjectSecurity(getPrimaryServerID,
                                     objName.text,
                                     readAccess,
                                     writeAccess) then
               begin
                 okBox('Object Saved Successfully') ;
                 close;
               end
             else
               alertBox('Error Writing To Object;;Check Access Rights') ;
          end;
      end;
  end;

procedure TWinObjEdit.objTypeClick(Sender: TObject);
  begin
    { never on new objects }

    { only for new objects }
    if (not creating) then
      begin
        bProperties.enabled  := true  ;
        { can't change existing object's type or duration }
        duration.enabled     := false ;
        objType.enabled      := false ;
      end;

    case objType.itemIndex of
      0:  {user object }
        begin
          readFlags.itemIndex  := 1 ;     { logged-in read }
          writeFlags.itemIndex := 2 ;    { object write }
          bgroups.enabled      := (not creating) ;
          password.enabled     := (not creating) ;
          bRights.enabled      := (not creating) ;
          bMembers.enabled     := false ;
        end;
      1:  { Group Object }
        begin
          readFlags.itemIndex  := 1 ;     { logged-in read }
          writeFlags.itemIndex := 3 ;    { super write }
          bMembers.enabled     := (not creating) ;
          bRights.enabled      := (not creating) ;
          bGroups.enabled      := false ;
          password.enabled     := false ;
        end;
      2:  { PrintQ Object }
        begin
          readFlags.itemIndex  := 1 ;     { logged-in read }
          writeFlags.itemIndex := 3 ;    { super write }
          password.enabled     := false ;
          fullName.enabled     := false ;
          bMembers.enabled     := false ;
          bRights.enabled      := false ;
          bGroups.enabled      := false ;
        end;
      3:  { Print Server Object }
        begin
          readFlags.itemIndex  := 1 ;     { logged-in read }
          writeFlags.itemIndex := 3 ;    { super write }
          password.enabled     := (not creating) ;
          bMembers.enabled     := false ;
          bRights.enabled      := false ;
          bGroups.enabled      := false ;
        end;
    end;
  end;

procedure TwinObjEdit.bMembersClick(Sender: TObject);
  begin
    try
      application.createForm(TWinList,winList) ;
      winList.inObjectName := objName.text ;
      winList.inServer     := getPrimaryServerID ;
      { set the form's onShow event }
      winList.onShow       := winList.onMemberShow ;
      winList.showModal ;
    finally
      winList.free  ;
    end;
  end;

procedure TwinObjEdit.bPropertiesClick(Sender: TObject);
  begin
    try
      application.createForm(TWinList,winList) ;
      winList.inObjectName := objName.text ;
      winList.inServer     := getPrimaryServerID ;
      { set the form's onShow event }
      winList.onShow       := winList.onPropertiesShow ;
      winList.showModal ;
    finally
      winList.free  ;
    end;
  end;


procedure TwinObjEdit.bGroupsClick(Sender: TObject);
  begin
    try
      application.createForm(TWinList,winList) ;
      winList.inObjectName := objName.text ;
      winList.inServer     := getPrimaryServerID ;
      { set the form's onShow event }
      winList.onShow       := winList.onGroupShow ;
      winList.showModal ;
    finally
      winList.free  ;
    end;
  end;

procedure TwinObjEdit.bRightsClick(Sender: TObject);
  begin
    { Show Object's Trustee Rights List }
    try
      application.createForm(TWinList,winList) ;
      winList.inObjectName := objName.text ;
      winList.inServer     := getPrimaryServerID ;
      { set the form's onShow event }
      winList.onShow       := winList.onRightsShow ;
      winList.showModal ;
    finally
      winList.free ;
    end;
  end;



{ end of unit }
end.
